/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.floating;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import xyz.przemyk.simpleplanes.client.render.UpgradesModels;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public class FloatingUpgrade
extends Upgrade {
    public static final ResourceLocation TEXTURE = new ResourceLocation("simpleplanes", "textures/plane_upgrades/floating.png");
    public static final ResourceLocation LARGE_TEXTURE = new ResourceLocation("simpleplanes", "textures/plane_upgrades/floating_large.png");
    public static final ResourceLocation HELICOPTER_TEXTURE = new ResourceLocation("simpleplanes", "textures/plane_upgrades/floating_helicopter.png");

    public FloatingUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)((Object)SimplePlanesUpgrades.FLOATY_BEDDING.get()), planeEntity);
    }

    @Override
    public void tick() {
        if (this.planeEntity.getHealth() > 0 && this.planeEntity.isOnWater()) {
            Vec3 motion = this.planeEntity.m_20184_();
            double f = 1.0;
            double y = Mth.m_14139_((double)1.0, (double)motion.f_82480_, (double)Math.max(motion.f_82480_, 0.0));
            this.planeEntity.m_20334_(motion.f_82479_ * f, y, motion.f_82481_ * f);
            if (this.planeEntity.f_19853_.m_8055_(new BlockPos(this.planeEntity.m_20182_().m_82520_(0.0, 0.5, 0.0))).m_60734_() == Blocks.f_49990_) {
                this.planeEntity.m_20256_(this.planeEntity.m_20184_().m_82520_(0.0, 0.04, 0.0));
            }
        }
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        EntityType entityType = this.planeEntity.m_6095_();
        if (entityType == SimplePlanesEntities.HELICOPTER.get()) {
            UpgradesModels.HELICOPTER_FLOATING.m_7695_(matrixStack, buffer.m_6299_(UpgradesModels.HELICOPTER_FLOATING.m_103119_(HELICOPTER_TEXTURE)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (entityType == SimplePlanesEntities.LARGE_PLANE.get()) {
            UpgradesModels.LARGE_FLOATING.m_7695_(matrixStack, buffer.m_6299_(UpgradesModels.LARGE_FLOATING.m_103119_(LARGE_TEXTURE)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            UpgradesModels.FLOATING.m_7695_(matrixStack, buffer.m_6299_(UpgradesModels.FLOATING.m_103119_(TEXTURE)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public void writePacket(FriendlyByteBuf buffer) {
    }

    @Override
    public void readPacket(FriendlyByteBuf buffer) {
    }

    @Override
    public void onRemoved() {
        this.planeEntity.m_19998_((ItemLike)SimplePlanesItems.FLOATY_BEDDING.get());
    }
}

